/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetASCII;
import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.CharsetProviderICU;
import com.ibm.icu.charset.CharsetUTF32;
import com.ibm.icu.text.UnicodeSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;

public abstract class CharsetICU
extends Charset {
    String icuCanonicalName;
    int options;
    float maxCharsPerByte;
    String name;
    int codepage;
    byte platform;
    byte conversionType;
    int minBytesPerChar;
    int maxBytesPerChar;
    byte[] subChar;
    byte subCharLen;
    byte hasToUnicodeFallback;
    byte hasFromUnicodeFallback;
    short unicodeMask;
    byte subChar1;
    public static final int ROUNDTRIP_SET = 0;
    @Deprecated
    public static final int ROUNDTRIP_AND_FALLBACK_SET = 1;
    private static final HashMap<String, String> algorithmicCharsets = new HashMap();

    protected CharsetICU(String icuCanonicalName, String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
        if (canonicalName.length() == 0) {
            throw new IllegalCharsetNameException(canonicalName);
        }
        this.icuCanonicalName = icuCanonicalName;
    }

    @Override
    public boolean contains(Charset cs) {
        if (null == cs) {
            return false;
        }
        return this.equals(cs);
    }

    static final Charset getCharset(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        String className = algorithmicCharsets.get(icuCanonicalName);
        if (className == null) {
            className = "com.ibm.icu.charset.CharsetMBCS";
        }
        try {
            CharsetICU conv = null;
            Class<CharsetICU> cs = Class.forName(className).asSubclass(CharsetICU.class);
            Class[] paramTypes = new Class[]{String.class, String.class, String[].class};
            Constructor<CharsetICU> c = cs.getConstructor(paramTypes);
            Object[] params = new Object[]{icuCanonicalName, javaCanonicalName, aliases};
            try {
                conv = c.newInstance(params);
                if (conv != null) {
                    return conv;
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                UnsupportedCharsetException e2 = new UnsupportedCharsetException(icuCanonicalName + ": " + "Could not load " + className + ". Exception: " + cause);
                e2.initCause(cause);
                throw e2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        throw new UnsupportedCharsetException(icuCanonicalName + ": " + "Could not load " + className);
    }

    static final boolean isSurrogate(int c) {
        return (c & 0xFFFFF800) == 55296;
    }

    public static Charset forNameICU(String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        CharsetProviderICU icuProvider = new CharsetProviderICU();
        CharsetICU cs = (CharsetICU)icuProvider.charsetForName(charsetName);
        if (cs != null) {
            return cs;
        }
        return Charset.forName(charsetName);
    }

    abstract void getUnicodeSetImpl(UnicodeSet var1, int var2);

    public void getUnicodeSet(UnicodeSet setFillIn, int which) {
        if (setFillIn == null || which != 0) {
            throw new IllegalArgumentException();
        }
        setFillIn.clear();
        this.getUnicodeSetImpl(setFillIn, which);
    }

    public boolean isFixedWidth() {
        if (this instanceof CharsetASCII || this instanceof CharsetUTF32) {
            return true;
        }
        return this instanceof CharsetMBCS && ((CharsetMBCS)this).sharedData.staticData.maxBytesPerChar == ((CharsetMBCS)this).sharedData.staticData.minBytesPerChar;
    }

    static void getNonSurrogateUnicodeSet(UnicodeSet setFillIn) {
        setFillIn.add(0, 55295);
        setFillIn.add(57344, 0x10FFFF);
    }

    static void getCompleteUnicodeSet(UnicodeSet setFillIn) {
        setFillIn.add(0, 0x10FFFF);
    }

    static {
        algorithmicCharsets.put("LMBCS-1", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-2", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-3", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-4", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-5", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-6", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-8", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-11", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-16", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-17", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-18", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("LMBCS-19", "com.ibm.icu.charset.CharsetLMBCS");
        algorithmicCharsets.put("BOCU-1", "com.ibm.icu.charset.CharsetBOCU1");
        algorithmicCharsets.put("SCSU", "com.ibm.icu.charset.CharsetSCSU");
        algorithmicCharsets.put("US-ASCII", "com.ibm.icu.charset.CharsetASCII");
        algorithmicCharsets.put("ISO-8859-1", "com.ibm.icu.charset.Charset88591");
        algorithmicCharsets.put("UTF-16", "com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-16BE", "com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16BE,version=1", "com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16LE", "com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF-16LE,version=1", "com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_OppositeEndian", "com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_PlatformEndian", "com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-32", "com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-32BE", "com.ibm.icu.charset.CharsetUTF32BE");
        algorithmicCharsets.put("UTF-32LE", "com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_OppositeEndian", "com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_PlatformEndian", "com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-8", "com.ibm.icu.charset.CharsetUTF8");
        algorithmicCharsets.put("CESU-8", "com.ibm.icu.charset.CharsetCESU8");
        algorithmicCharsets.put("UTF-7", "com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("ISCII,version=0", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=1", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=2", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=3", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=4", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=5", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=6", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=7", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=8", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("IMAP-mailbox-name", "com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("HZ", "com.ibm.icu.charset.CharsetHZ");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=0", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=1", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=2", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=3", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ja,version=4", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=0", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=1", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=zh,version=2", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ko,version=0", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("ISO_2022,locale=ko,version=1", "com.ibm.icu.charset.CharsetISO2022");
        algorithmicCharsets.put("x11-compound-text", "com.ibm.icu.charset.CharsetCompoundText");
    }
}

